/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.core.milestones;

import filenet.vw.api.VWMilestoneElement;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.resources.VWResource;
import filenet.vw.toolkit.utils.table.IVWTableOperation;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class VWMilestoneTableModel
extends AbstractTableModel
implements IVWTableOperation {
    private static final String[] m_headers = new String[]{VWResource.s_name, VWResource.s_message, VWResource.s_reached};
    private static final Class[] m_columnClasses = new Class[]{String.class, String.class, String.class};
    private Vector m_rowCache;
    private VWStepElement m_vwStepElement = null;
    private VWMilestoneElement[] m_vwMilestoneElements = null;

    public VWMilestoneTableModel(VWStepElement stepElement) {
        try {
            VWProcess process;
            this.m_vwStepElement = stepElement;
            if (this.m_vwStepElement != null && !this.m_vwStepElement.getIsLaunchStep() && (process = this.m_vwStepElement.fetchProcess()) != null) {
                this.m_vwMilestoneElements = process.fetchFilteredWorkflowMilestones(1, true, true);
                this.retrieveRowData();
            }
            this.fireTableChanged(null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getColumnCount() {
        return m_headers.length;
    }

    public Class getColumnClass(int index) {
        return m_columnClasses[index];
    }

    public String getColumnName(int index) {
        return m_headers[index];
    }

    public int getRowCount() {
        return this.m_rowCache.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object cellObject = this.getCellElement(rowIndex, columnIndex);
        return cellObject;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void openItem(int rowIndex) {
    }

    public void refresh() {
    }

    protected void retrieveRowData() {
        VWMilestoneElement vwMilestoneElement = null;
        Date timeStamp = null;
        try {
            this.m_rowCache = new Vector();
            if (this.m_vwMilestoneElements == null || this.m_vwMilestoneElements.length == 0) {
                return;
            }
            for (int i = 0; i < this.m_vwMilestoneElements.length; ++i) {
                vwMilestoneElement = this.m_vwMilestoneElements[i];
                if (vwMilestoneElement == null) continue;
                Object[] rowData = new Object[this.getColumnCount()];
                rowData[0] = vwMilestoneElement.getName();
                rowData[1] = vwMilestoneElement.getMessage();
                timeStamp = vwMilestoneElement.getTimestamp();
                rowData[2] = timeStamp != null ? DateFormat.getDateTimeInstance(2, 2).format(timeStamp) : "";
                this.m_rowCache.addElement(rowData);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected Object getCellElement(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        if (columnIndex > this.getColumnCount() - 1) {
            return null;
        }
        return ((Object[])this.m_rowCache.elementAt(rowIndex))[columnIndex];
    }
}

